import java.awt.*;
import javax.swing.*;
import java.awt.geom.*;

public class ClockView extends JPanel {
	private ClockModel model;
	private static final double CD= 200;		// Clock diameter
	private static final double X= 100;			// Dist from upper lh corner
	private static final double Y= 50;			// Dist from upper lh corner
	private static final double XC= X + CD/2;	// Clock center x
	private static final double YC= Y + CD/2;	// Clock center y
	private static final double HR= 0.3*CD;		// Size of hour hand
	private static final double MI= 0.45*CD;	// Size of minute hand

	public ClockView(ClockModel cm) {
		model = cm;
	}

	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		Graphics2D g2 = (Graphics2D) g;
		double minutes= model.getMinutes();
		double hourAngle = 2 * Math.PI * (minutes - 3 * 60) / (12 * 60);
		double minuteAngle = 2 * Math.PI * (minutes - 15) / 60;
		
		Ellipse2D.Double e = new Ellipse2D.Double(X, Y, CD, CD);
		Line2D hr= new Line2D.Double(XC, YC, XC + (HR * Math.cos(hourAngle)),
			YC+ (HR * Math.sin(hourAngle)) );
		Line2D mi= new Line2D.Double(XC, YC, XC + (MI * Math.cos(minuteAngle)),
			YC+ (MI * Math.sin(minuteAngle)) );	
			
		g2.setPaint(Color.BLUE);
		BasicStroke bs= new BasicStroke(5.0F, 
			BasicStroke.CAP_BUTT, BasicStroke.JOIN_BEVEL);
		g2.setStroke(bs);
		g2.draw(e);
		g2.draw(hr);
		g2.draw(mi);
	}
}